(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     85487,       2661]*)
(*NotebookOutlinePosition[     87144,       2711]*)
(*  CellTagsIndexPosition[     87070,       2705]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Campos vectoriales. Integrales de l\[IAcute]nea", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Campos vectoriales", "Section"],

Cell[TextData[{
  "Recuerda que un ",
  StyleBox["campo escalar",
    FontWeight->"Bold"],
  " de n variables es una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " donde ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es un subconjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ". Un ",
  StyleBox["campo vectorial",
    FontWeight->"Bold"],
  " es una funci\[OAcute]n que a cada punto de una regi\[OAcute]n de un \
espacio vectorial hace corresponder un vector de dicho espacio. \
Concretamente, un campo vectorial de n variables es una aplicaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", "A"}], "\[Rule]", " ", 
          FormBox[\(\[DoubleStruckCapitalR]\^n\),
            "TraditionalForm"]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " es un subconjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ". Dicha funci\[OAcute]n debe ser de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", "x", ")"}], "=", 
          \((\(F\_1\)(x), \(F\_2\)(x),  ... , \(F\_n\)(x))\)}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`F\_1, \ F\_2,  .. , F\_\(n\ \)\)]],
  "son campos escalares de n variables llamados ",
  StyleBox["componentes",
    FontWeight->"Bold"],
  " de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Se dice que ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es continuo o que tiene derivadas parciales o que es de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^k\)]],
  " (tiene derivadas parciales de orden k continuas) cuando todos los campos \
escalares componentes de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " tienen la correspondiente propiedad. Por ejemplo, las funciones"
}], "Text"],

Cell[BoxData[{
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], "(", \(x, y\), ")"}], "=", 
        RowBox[{\((x\/\(\(\ \)\(1 + x\^2 + y\^2\)\), \(-y\)\/\(1 + x\^2 + \
y\^2\))\), "=", 
          RowBox[{
            RowBox[{\(x\/\(\(\ \)\(1 + x\^2 + y\^2\)\)\), 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], " ", "-", " ", 
            RowBox[{\(y\/\(1 + x\^2 + y\^2\)\), 
              StyleBox["j",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}]}], TraditionalForm], "\n", 
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["G",
            FontWeight->"Bold",
            FontSlant->"Italic"], "(", \(x, y, z\), ")"}], "=", 
        RowBox[{\((\(-x\)\/\(\(\ \)\(1 + x\^2\)\), \(-y\)\/\(1 + y\^2\), \(-z\
\)\/\(1 + z\^2\))\), "=", 
          RowBox[{
            RowBox[{\(-\(x\/\(1 + \ x\^2\)\)\), 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], " ", "-", " ", 
            RowBox[{\(y\/\(\(\ \)\(1 + y\^2\)\)\), 
              StyleBox["j",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], " ", "-", " ", 
            RowBox[{\(z\/\(\(\ \)\(1 + z\^2\)\)\), 
              StyleBox["k",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}]}], TraditionalForm]}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "son campos vectoriales de 2 y 3 variables de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^\[Infinity]\)]],
  "definidos en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleStruckCapitalR]\^2\ \)\)]],
  "y en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " respectivamente. Como puedes ver, nada nuevo hay en el concepto de campo \
vectorial pues se trata de un tipo particular de funciones que ya conoces. \
Ahora bien, cuando decimos que una funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", "A"}], "\[Rule]", " ", 
          FormBox[\(\[DoubleStruckCapitalR]\^n\),
            "TraditionalForm"]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^n\)]],
  " es un campo vectorial es porque la visualizamos de una forma especial y \
consideramos que dicha funci\[OAcute]n hace corresponder a cada vector ",
  Cell[BoxData[
      \(TraditionalForm\`\(x \[Element] A\ \)\)]],
  "el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", "x", ")"}], TraditionalForm]]],
  " ",
  StyleBox["con origen en el punto",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de los comandos"
}], "Text"],

Cell["\<\
PlotVectorField[f[x,y],{x,xmin,xmax},{y,ymin,ymax},opciones] \
PlotVectorField3D[f[x,y,z],{x,xmin,xmax},{y,ymin,ymax},{z,zmin,zmax},opciones]\
 \
\>", "Text",
  TextAlignment->Center],

Cell["\<\
para representa gr\[AAcute]ficamente campos vectoriales de 2 y 3 variables \
respectivamente. Para poder usarlos hay que cargar los correspondientes \
paquetes.\
\>", "Text"],

Cell["<<Graphics`PlotField`", "Input",
  CellTags->"S5.42.1"],

Cell["<<Graphics`PlotField3D`", "Input",
  CellTags->"S5.42.1"],

Cell[BoxData[{
    \(F[x_, y_] := {x\/\(\ 1 + x\^2 + y\^2\), \(-y\)\/\(1 + x\^2 + y\^2\)}
        \), 
    \(PlotVectorField[\ F[x, y], {x, \(-1\), 1}, {y, \(-1\), 1}]; \n
    Clear[F]\)}], "Input"],

Cell[BoxData[{
    \(G[x_, y_, z_] := {\(-x\)\/\(\ 1 + x\^2\), \(-y\)\/\(1 + y\^2\), 
        \(-z\)\/\(1 + z\^2\)}\), 
    \(PlotVectorField3D[\ 
      G[x, y, z], {x, \(-1\), 1}, {y, \(-1\), 1}, {z, \(-1\), 1}, 
      VectorHeads -> True, ColorFunction -> Hue]; \nClear[G]\)}], "Input"],

Cell["\<\
En general, los campos vectoriales de 2 variables son funciones de la forma\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
        RowBox[{\((P(x, y), Q(x, y))\), "=", 
          RowBox[{
            RowBox[{"P", \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], "+", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["\<\
y los campos vectoriales de 3 variables son funciones de la forma\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
        RowBox[{\((P(x, y, z), Q(x, y, z), R(x, y, z))\), "=", 
          RowBox[{
            RowBox[{\(P(x, y, z)\), 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], "+", 
            RowBox[{\(Q(x, y, z)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(R(x, y, z)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["Ejemplos", "Example"],

Cell[TextData[{
  StyleBox["Campo gravitacional",
    FontWeight->"Bold"],
  ". La ley de la gravitaci\[OAcute]n de Newton establece que la norma eucl\
\[IAcute]dea (la magnitud se dice en f\[IAcute]sica) de la  fuerza (no \
olvides que la fueza es un vector) de atracci\[OAcute]n gravitacional, ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", entre dos objetos de masas ",
  StyleBox["m",
    FontSlant->"Italic"],
  " y ",
  StyleBox["M",
    FontSlant->"Italic"],
  " es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"||", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], "||"}], "=", 
        FractionBox[
          StyleBox[\(m\ M\ G\),
            FontSlant->"Italic"], 
          SuperscriptBox[
            StyleBox["r",
              FontSlant->"Italic"], "2"]]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  StyleBox["r",
    FontSlant->"Italic"],
  " es la distancia eucl\[IAcute]dea entre dichos objetos y ",
  StyleBox["G",
    FontSlant->"Italic"],
  " es la constante gravitacional universal. Si el objeto de masa ",
  StyleBox["M",
    FontSlant->"Italic"],
  " se encuentra en el origen y el objeto de masa ",
  StyleBox["m",
    FontSlant->"Italic"],
  " se encuentra en un punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "=", \((x, y, z)\)}], TraditionalForm]]],
  ", entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{"r", "=", 
          RowBox[{"||", 
            StyleBox["r",
              FontWeight->"Bold"], "||"}]}], TraditionalForm]]],
  ". Como, adem\[AAcute]s, la fuerza ejercida por el objeto de masa ",
  StyleBox["M",
    FontSlant->"Italic"],
  " sobre el objeto de masa ",
  StyleBox["m",
    FontSlant->"Italic"],
  " est\[AAcute] dirigida desde \[EAcute]ste hacia el origen y un vector \
unitario en dicha direcci\[OAcute]n es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["r",
                FontWeight->"Bold"]}], "/"}], "||", 
          StyleBox["r",
            FontWeight->"Bold"], "||"}], TraditionalForm]]],
  ", deducimos que dicha fuerza viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(F \((r)\)\),
          FontWeight->"Bold",
          FontSlant->"Italic"], "=", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              StyleBox[\(m\ M\ G\),
                FontSlant->"Italic"], 
              RowBox[{"||", 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \( || \^3\)}]]}], 
          StyleBox["r",
            FontWeight->"Bold",
            FontSlant->"Italic"]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Esta igualdad vectorial puede escribirse tambi\[EAcute]n en la forma:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain",
              FontSlant->"Italic"], ")"}]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["-",
                FontWeight->"Plain"], 
              StyleBox[
                FractionBox[\(m\ M\ G\ x\), 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{\(x\^2\), 
                        StyleBox["+",
                          FontSlant->"Plain"], \(y\^2\), 
                        StyleBox["+",
                          FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
                FontWeight->"Plain",
                FontSlant->"Italic"]}], 
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], " ", 
          StyleBox["-",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[
              FractionBox[\(m\ M\ G\ y\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["j",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox["-",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[
              FractionBox[\(m\ M\ G\ z\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["k",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center,
  FontWeight->"Bold"],

Cell[TextData[{
  StyleBox["Campo el\[EAcute]ctrico producido por una carga.",
    FontWeight->"Bold"],
  "  La ley de Coulomb establece que la norma eucl\[IAcute]dea (la magnitud \
se dice en f\[IAcute]sica) de la fuerza (no olvides que la fuerza es un \
vector), ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", ejercida entre dos cargas el\[EAcute]ctricas ",
  StyleBox["q",
    FontSlant->"Italic"],
  " y ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"||", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], "||"}], "=", 
        FractionBox[
          StyleBox[\(\(\ \)\(\(|\)\(q\ Q\)\(|\)\)\),
            FontSlant->"Italic"], \(4  \[Pi]\ \[Epsilon]\ r\^2\)]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  StyleBox["r",
    FontSlant->"Italic"],
  " es la distancia eucl\[IAcute]dea entre dichas cargas y ",
  StyleBox["\[Epsilon]",
    FontSlant->"Italic"],
  "  es una constante. Si la carga ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " se encuentra en el origen y la carga ",
  StyleBox["q",
    FontSlant->"Italic"],
  " se encuentra en un punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], "=", \((x, y, z)\)}], TraditionalForm]]],
  ", entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{"r", "=", 
          RowBox[{"||", 
            StyleBox["x",
              FontWeight->"Bold"], "||"}]}], TraditionalForm]]],
  ". Como, adem\[AAcute]s, la fuerza ejercida por la carga ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " sobre la carga ",
  StyleBox["q ",
    FontSlant->"Italic"],
  "act\[UAcute]a en la direcci\[OAcute]n del segmento de recta que une ambas \
cargas y es atractiva o repulsiva seg\[UAcute]n que ambas cargas sean de \
distinto o de igual signo, y un vector unitario en la direcci\[OAcute]n del \
vector ",
  StyleBox["x",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "/"}], "||", 
          StyleBox["x",
            FontWeight->"Bold"], "||"}], TraditionalForm]]],
  ", deducimos que dicha fuerza viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(F \((x)\)\),
          FontWeight->"Bold",
          FontSlant->"Italic"], "=", 
        RowBox[{
          FractionBox[
            StyleBox[\(\(\ \)\(q\ Q\)\),
              FontSlant->"Italic"], 
            RowBox[{\(4  \[Pi]\ \[Epsilon]\), "||", 
              StyleBox["x",
                FontWeight->"Bold",
                FontSlant->"Italic"], \( || \^3\)}]], 
          StyleBox["x",
            FontWeight->"Bold",
            FontSlant->"Italic"]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La fuerza ejercida por unidad de carga es, por definici\[OAcute]n, el \
campo el\[EAcute]ctrico, ",
  StyleBox["E",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", creado por la carga ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " que viene dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(E \((x)\)\),
          FontWeight->"Bold",
          FontSlant->"Italic"], "=", 
        RowBox[{
          FractionBox[
            StyleBox[\(F \((x)\)\),
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["q",
              FontSlant->"Italic"]], "=", 
          RowBox[{
            StyleBox[
              FractionBox[
                StyleBox["Q",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox[\(4  \[Pi]\ \[Epsilon]\),
                    FontSlant->"Plain"], 
                  StyleBox["||",
                    FontSlant->"Plain"], 
                  StyleBox["x",
                    FontWeight->"Bold"], 
                  SuperscriptBox[
                    StyleBox["||",
                      FontSlant->"Plain"], 
                    StyleBox["3",
                      FontSlant->"Plain"]]}]],
              FontSlant->"Italic"], 
            StyleBox["x",
              FontWeight->"Bold",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["Campos de gradiente",
    FontWeight->"Bold"],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " donde ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es un subconjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " un campo escalar de n variables. El ",
  StyleBox["gradiente",
    FontWeight->"Bold"],
  " de dicho campo escalar en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((x\_1, \ x\_2,  ... , x\_n)\) \[Element] 
          A\)]],
  " es, por definici\[OAcute]n, el vector "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Del]\(f(
          x)\) = \((\(\[PartialD]f\/\[PartialD]\ 
                x\_1\) \((x)\), \ \(\[PartialD]f\/\[PartialD]\ 
                x\_2\) \((x)\),  ... , \(\[PartialD]f\/\[PartialD]\ 
                x\_n\) \((x)\))\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f : A\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " que a cada ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] A\)]],
  " hace corresponder el gradiente de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "se llama",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["campo vectorial gradiente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" de f.",
    FontSlant->"Italic"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrales de l\[IAcute]nea", "Section"],

Cell[CellGroupData[{

Cell["Integral de l\[IAcute]nea de un campo escalar", "Subsection"],

Cell[TextData[{
  StyleBox["Sea ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\^n\)],
    FontFamily->"Times New Roman"],
  StyleBox[" una curva con derivada continua y sea ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)],
    FontFamily->"Times New Roman"],
  StyleBox[" un campo escalar continuo definido en un conjunto ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^n\)],
    FontFamily->"Times New Roman"],
  " que contiene a la imagen de \[Gamma], esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](\([a, b]\)) \[Subset] A\)]],
  ". La integral de l\[IAcute]nea de ",
  StyleBox["f  ",
    FontSlant->"Italic"],
  "sobre la curva",
  StyleBox[" ",
    FontSlant->"Italic"],
  "\[Gamma] es el n\[UAcute]mero"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}]}], "||", 
          \(\[Gamma]' \((t)\)\), "||", \(\[DifferentialD]t\)}]}], TextForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para ",
  Cell[BoxData[
      \(TraditionalForm\`n = 2\)]],
  ", poniendo ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  ", la integral anterior es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{\(\[Integral]\_a\%b\), 
          RowBox[{
            StyleBox["f",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x \((t)\), y \((t)\)\),
                FontSlant->"Italic"], ")"}], 
            SqrtBox[
              RowBox[{
                StyleBox[\(x\ ' \((t)\)\^2\),
                  FontSlant->"Italic"], 
                StyleBox["+",
                  FontSlant->"Plain"], 
                StyleBox[\(y\ ' \((t)\)\^2\),
                  FontSlant->"Italic"]}]], \(\[DifferentialD]t\)}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para",
  Cell[BoxData[
      \(TraditionalForm\`\(\ n = 3\)\)]],
  ", poniendo ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t), \ z(t))\)\)]],
  ", la integral anterior es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{\(\[Integral]\_a\%b\), 
          RowBox[{
            StyleBox["f",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x \((t)\), y \((t)\), \ z \((t)\)\),
                FontSlant->"Italic"], ")"}], 
            SqrtBox[
              RowBox[{
                StyleBox[\(x\ ' \((t)\)\^2\),
                  FontSlant->"Italic"], 
                StyleBox["+",
                  FontSlant->"Plain"], 
                StyleBox[\(y\ ' \((t)\)\^2\),
                  FontSlant->"Italic"], "+", 
                StyleBox[\(z\ ' \((t)\)\^2\),
                  FontSlant->"Italic"]}]], \(\[DifferentialD]t\)}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["OBSERVACIONES",
    FontWeight->"Bold"],
  ". Suelen usarse distintas notaciones para las integrales de l\[IAcute]nea. \
Es frecuente la notaci\[OAcute]n"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Integral]\_\[Gamma]\), 
        RowBox[{
          RowBox[{
            StyleBox["f",
              FontSlant->"Italic"], "(", \(x, y\), ")"}], 
          RowBox[{"\[DifferentialD]", 
            StyleBox["s",
              FontSlant->"Italic"]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "en la cual el s\[IAcute]mbolo \[DifferentialD]",
  StyleBox["s ",
    FontSlant->"Italic"],
  "indica que se integra respecto al elemento diferencial de longitud de \
arco. Esta notaci\[OAcute]n est\[AAcute] de acuerdo con el hecho de que \
cuando la funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " es la funci\[OAcute]n constantemente igual a 1 se tiene que "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Integral]\_\[Gamma] 1\), "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), " ", 
            RowBox[{"1", 
              RowBox[{"\[DifferentialD]", 
                StyleBox["s",
                  FontSlant->"Italic"]}]}]}], "=", 
          \(\[Integral]\_a\%b\(\( || \[Gamma]'\) \((t)\) || 
              \[DifferentialD]t\)\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[
"es la longitud de la curva \[Gamma]. Cuando la curva \[Gamma] es una curva \
cerrada a algunos les gusta usar alguno de los s\[IAcute]mbolos"], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[ContourIntegral]\_\[Gamma]\), 
        RowBox[{
          RowBox[{
            StyleBox["f",
              FontSlant->"Italic"], "(", \(x, y\), ")"}], 
          RowBox[{"\[DifferentialD]", 
            StyleBox["s",
              FontSlant->"Italic"]}], 
          StyleBox[
            RowBox[{
              StyleBox[" ",
                FontSlant->"Italic"], "       "}]], "o", "                ", 
          RowBox[{
            SubscriptBox[
              StyleBox["\[CounterClockwiseContourIntegral]",
                FontSlant->"Italic"], "\[Gamma]"], 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontSlant->"Italic"], "(", \(x, y\), ")"}], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["s",
                  FontSlant->"Italic"]}]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "para indicar la integral de l\[IAcute]nea de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " sobre \[Gamma] (en el segundo s\[IAcute]mbolo la flechita indica que la \
curva tiene determinada orientaci\[OAcute]n; estudiaremos esto m\[AAcute]s \
adelante). No necesito decirte que no debes preocuparte por el \
s\[IAcute]mbolo que se usa sino que lo importante es comprender bien la \
definici\[OAcute]n de lo que dicho s\[IAcute]mbolo significa. "
}], "Text"],

Cell[TextData[{
  "Cuando la funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " es positiva, el valor de la integral de l\[IAcute]nea ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], TextForm]]],
  " puede interpretarse como el \[AAcute]rea de un lado de una cortina que \
cuelga de un alambre cuya forma viene dada por la curva \[Gamma] y cuya \
altura en cada punto \[Gamma](t) viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`f(\[Gamma](t))\)]],
  ". \nOtra posible interpretaci\[OAcute]n es cuando ",
  StyleBox["f",
    FontSlant->"Italic"],
  "(\[Gamma](t)) es la densidad lineal en el punto \[Gamma](t) de un alambre \
cuya forma viene dada por la curva \[Gamma]; en tal caso la integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], TextForm]]],
  " nos da la masa total del alambre. El ",
  StyleBox["centro de masas ",
    FontWeight->"Bold"],
  "del alambre es el punto de coordenadas (\[Alpha], \[Beta]) dadas por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{"\[Alpha]", "=", 
            StyleBox[
              FractionBox[
                FormBox[
                  RowBox[{\(\[Integral]\_\[Gamma]\), " ", 
                    RowBox[{"x", " ", 
                      StyleBox[\(f(x, y)\),
                        FontSlant->"Italic"], 
                      RowBox[{
                        StyleBox["\[DifferentialD]",
                          FontSlant->"Plain"], 
                        StyleBox["s",
                          FontSlant->"Italic"]}]}]}],
                  "TextForm"], 
                FormBox[
                  RowBox[{\(\[Integral]\_\[Gamma]\), 
                    StyleBox["f",
                      FontSlant->"Italic"]}],
                  "TextForm"]],
              FontWeight->"Bold"]}], ",", " ", 
          RowBox[{"\[Beta]", "=", " ", 
            StyleBox[
              FractionBox[
                FormBox[
                  RowBox[{\(\[Integral]\_\[Gamma]\), " ", 
                    RowBox[{"y", " ", 
                      StyleBox[\(f(x, y)\),
                        FontSlant->"Italic"], 
                      RowBox[{
                        StyleBox["\[DifferentialD]",
                          FontSlant->"Plain"], 
                        StyleBox["s",
                          FontSlant->"Italic"]}]}]}],
                  "TextForm"], 
                FormBox[
                  RowBox[{\(\[Integral]\_\[Gamma]\), 
                    StyleBox["f",
                      FontSlant->"Italic"]}],
                  "TextForm"]],
              FontWeight->"Bold"]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Cuando la densidad es constante el centro de masas se denomina ",
  StyleBox["centroide ",
    FontWeight->"Bold"],
  "(que es una propiedad geom\[EAcute]trica de la curva)."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Calcular las siguientes integrales de l\[IAcute]nea de la funci\[OAcute]n \
",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre la curva \[Gamma].\na)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2 - y\^2\)]],
  " , ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \[Pi]\)]],
  ".\nb)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 2  x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((\ t, \ \ t\^2)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ".\nc)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = y\ sen\ z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t, t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = x\ z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma](t) = \((6\ t, \ \ 3 \(\@ 2\) t\^2, 2  t\^3)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Calcula el \[AAcute]rea de la parte del cilindro ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = \ a\ x\)]],
  " que se encuentra dentro de la esfera ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + z\^2 = \ a\^2\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Calcula la masa total de un alambre cuya forma es la de la curva ",
  Cell[BoxData[
      \(TraditionalForm\`y = log\ x\)]],
  " comprendida entre ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1 = 1\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2 = \[ExponentialE]\)]],
  ", si la densidad lineal (gr/cm) en cada punto del alambre es igual al \
cuadrado de su abscisa."
}], "ExerciseText"],

Cell[TextData[{
  "Una integral de l\[IAcute]nea depende de DOS funciones: la funci\[OAcute]n \
 ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  y la funci\[OAcute]n \[Gamma]; necesitas conocer dichas funciones para \
poder calcular la integral. Cuando se intregra sobre curvas sencillas como, \
por ejemplo, un segmento o una circunferencia la funci\[OAcute]n \[Gamma] se \
da por sabida. Esto puede dar lugar a confusiones. Intentar\[EAcute] aclarar \
este punto."
}], "Text"],

Cell[TextData[{
  "Calculemos la integral de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2 + y\^2\)]],
  " sobre la circunferencia unidad ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", "=", 
          RowBox[{"{", 
            RowBox[{\((x, y)\), 
              
              FormBox[\(\( \[Element] \(\[DoubleStruckCapitalR]\^2\) : 
                      x\^2 + y\^2\) = 1}\),
                "TraditionalForm"]}]}]}], TraditionalForm]]],
  ", es decir, la circunferencia centrada en el origen y de radio 1. Dicha \
circunferencia viene dada por la funci\[OAcute]n",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Gamma](t) = \((cos\ t, \ sen\ t)\)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  " y tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], \((cos\ t, sen\ t)\), 
              \(\@\(\((\(-sen\)\ t)\)\^2 + \(cos\^2\) t\)\), 
              \(\[DifferentialD]t\)}]}], "=", 
          \(\[Integral]\_\(-\[Pi]\)\%\[Pi] 1 \[DifferentialD]t = 
            2  \[Pi]\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Pero tambi\[EAcute]n la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](t) = \((cos(2  t), sen(2  t))\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  " tiene como imagen la circunferencia unidad ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma]\)]],
  ", esto es ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Lambda](\([\(-\[Pi]\), \[Pi]]\)) = \[CapitalGamma]\)]],
  ", y se tiene que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Lambda]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], \((cos\ 2  t, sen\ 2  t)\), 
              \(\@\(\((\(-2\) sen\ 2  t)\)\^2 + 4 \( cos\^2\) t\)\), 
              \(\[DifferentialD]t\)}]}], "=", 
          \(\[Integral]\_\(-\[Pi]\)\%\[Pi] 2 \[DifferentialD]t = 
            4  \[Pi]\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "\[DownQuestion]Cu\[AAcute]l de estas dos integrales es la que nos piden \
cuando nos dicen que calculemos la integral de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2 + y\^2\)]],
  " sobre la circunferencia unidad? Lo usual es que nos pidan la primera de \
las dos integrales. Observa que la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Gamma](t) = \((cos\ t, \ sen\ t)\)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  " recorre la circunferencia unidad una sola vez, mientras que la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Lambda](t) = \((cos(2\ t), sen(2\ t))\)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  " recorre la circunferencia unidad dos veces. Es decir, ",
  StyleBox[
  "para calcular una integral de l\[IAcute]nea de una funci\[OAcute]n sobre \
una curva lo importante no es la imagen geom\[EAcute]trica de la curva",
    FontWeight->"Bold"],
  " (en este ejemplo una circunferencia) ",
  StyleBox[
  "sino la funci\[OAcute]n que la representa, es decir, c\[OAcute]mo se \
recorre dicha curva",
    FontWeight->"Bold"],
  " (en este ejemplo la funci\[OAcute]n \[Lambda] recorre la circunferencia \
con rapidez doble que \[Gamma]). Por esta misma raz\[OAcute]n una notaci\
\[OAcute]n como"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Integral]\_\[CapitalGamma]\), 
        StyleBox["f",
          FontSlant->"Italic"]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para representar la integral de l\[IAcute]nea de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre una curva ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalGamma] \[Subset] \[DoubleStruckCapitalR]\^n\)]],
  " no tiene sentido salvo que especifiquemos antes la forma en que dicha \
curva se recorre. En resumen, no debes confundir una curva \[Gamma], que es \
una funci\[OAcute]n, con su imagen, \[CapitalGamma], que es un conjunto de \
puntos. "
}], "Text"],

Cell[TextData[{
  "Como las integrales de l\[IAcute]nea en segmentos y en circunferencias \
aparecen mucho conviene introducir una notaci\[OAcute]n apropiada para ellas \
y precisar su significado. En adelante representaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`C(\((a, b)\), r)\)]],
  " la ",
  StyleBox["circunferencia",
    FontWeight->"Bold"],
  " de centro ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " y radio ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ". Dicha circunferencia es la imagen de la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([\(-\[Pi]\), \[Pi]]\) \[Rule] 
        \[DoubleStruckCapitalR]\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma](t) = \((a + r\ cos\ t, b + r\ \ sen\ t)\)\)]],
  ". Como ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{\(\( || \[Gamma]'\) \((t)\) || \), "=", 
            RowBox[{
              
              FormBox[\(\@\(\((\(-r\)\ sen\ t)\)\^2 + 
                      \(r\^2\) \(cos\^2\) t\)\),
                "TextForm"], "=", "r"}]}]}], TraditionalForm]]],
  ", si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es un campo escalar definido en los puntos de dicha circunferencia \
tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\(C \((\((a, b)\), r)\)\)\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          StyleBox["r",
            FontSlant->"Italic"], 
          RowBox[{\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"a", "+", 
                    RowBox[{
                      StyleBox["r",
                        FontSlant->"Italic"], " ", "cos", " ", "t"}]}], ",", 
                  RowBox[{"b", "+", 
                    RowBox[{
                      StyleBox["r",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontSlant->"Italic"], "sen", " ", "t"}]}]}], ")"}], 
              \(\[DifferentialD]t\)}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Debido a la periodicidad de las funciones seno y coseno, podemos \
reemplazar en la integral anterior el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-\[Pi]\), \[Pi]]\)\)]],
  " por cualquier intervalo de longitud 2\[Pi]; por ejemplo, ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, 2  \[Pi]]\)\)]],
  ".\nDados dos vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y ",
    FontSlant->"Italic"],
  "en",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " (n\[GreaterEqual]2) representaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`\([x, y]\)\)]],
  " el ",
  StyleBox["segmento",
    FontWeight->"Bold"],
  " que une ",
  StyleBox["x",
    FontSlant->"Italic"],
  " con ",
  StyleBox["y, ",
    FontSlant->"Italic"],
  "esto es, el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`{\((1 - t)\) x + t\ \(y : 0 \[LessEqual] t \[LessEqual] 1\)}\)]],
  ". Dicho segmento es la imagen de la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([0, 1]\) \[Rule] \[DoubleStruckCapitalR]\^n\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((1 - t)\) x\  + \ t\ y\)]],
  ". Como",
  Cell[BoxData[
      \(TraditionalForm\`\(\ 
      \(\( || \[Gamma]'\) \((t)\) || \) = \(\( || y - x\) || \)\)\)]],
  ", si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es un campo escalar definido en los puntos de dicho segmento tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\([x, y]\)\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{"||", 
          RowBox[{
            StyleBox["y",
              FontSlant->"Italic"], "-", 
            StyleBox["x",
              FontSlant->"Italic"]}], "||", 
          RowBox[{\(\[Integral]\_0\%1\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], 
              RowBox[{"(", 
                FormBox[\(\((1 - t)\) x + t\ y\),
                  "TraditionalForm"], ")"}], \(\[DifferentialD]t\)}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Con frecuencia es necesario calcular integrales de l\[IAcute]nea sobre \
curvas que no tienen derivada continua pero que pueden expresarse como una \
yuxtaposici\[OAcute]n de curvas con derivada continua. Estas curvas se llaman \
",
  StyleBox["curvas con derivada continua a trozos o",
    FontWeight->"Bold"],
  " ",
  StyleBox["caminos",
    FontWeight->"Bold"],
  ". Por ejemplo, si unimos varios segmentos uno a continuaci\[OAcute]n de \
otro obtenemos una ",
  StyleBox["poligonal",
    FontWeight->"Bold"],
  " que es un tipo frecuente de camino. Otro ejemplo puedes verlo en la gr\
\[AAcute]fica siguiente."
}], "Text"],

Cell[BoxData[
    \(f[x_] := x\^2 /; 0 \[LessEqual] x < 1; \n
    f[x_] := \((2 - x)\)\^4 /; 1 \[LessEqual] x < 1.5; \n
    f[x_] :=  .5\^4 + \((x - 1.5)\) /; 1.5 \[LessEqual] x \[LessEqual] 2; \n
    Plot[f[x], {x, 0, 2}, AspectRatio -> Automatic, 
      PlotStyle -> Thickness[ .007], 
      Epilog -> {Text[\*"\"\<\!\(\[Gamma]\_1\)\>\"", { .5,  .4}], 
          Text[\*"\"\<\!\(\[Gamma]\_2\)\>\"", {1.3,  .4}], 
          Text[\*"\"\<\!\(\[Gamma]\_3\)\>\"", {1.73,  .4}]}]; \nClear[f]\)], 
  "Input"],

Cell[TextData[{
  "En esta gr\[AAcute]fica las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1, \ \[Gamma]\_2, \ \[Gamma]\_3\)]],
  " se yuxtaponen para formar un camino que llamaremos \[Gamma]. En estas \
circunstancias se define"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), 
            StyleBox["f",
              FontSlant->"Italic"]}], 
          StyleBox["+",
            FontSlant->"Plain"], 
          RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), 
            StyleBox["f",
              FontSlant->"Italic"]}], "+", 
          RowBox[{\(\[Integral]\_\(\[Gamma]\_3\)\), 
            StyleBox["f",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es decir para integrar una funci\[OAcute]n sobre un camino se suman las \
integrales de dicha funci\[OAcute]n sobre las curvas con derivada continua \
que forman dicho camino. Por ejemplo, si usamos la notaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\([z\_1, z\_2,  ... , z\_n]\)\)]],
  " para indicar una poligonal cuyos v\[EAcute]rtices son ",
  Cell[BoxData[
      \(TraditionalForm\`z\_1, \ z\_2,  ... , \ z\_n\)]],
  ", entonces"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\([z\_1, z\_2,  .. , z\_n]\)\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{\(\[Integral]\_\([z\_1, z\_2]\)\), 
                StyleBox["f",
                  FontSlant->"Italic"]}], 
              StyleBox["+",
                FontSlant->"Plain"], 
              RowBox[{\(\[Integral]\_\([z\_2, z\_3]\)\), 
                StyleBox["f",
                  FontSlant->"Italic"]}], "+"}], "..."}], "+", 
          RowBox[{\(\[Integral]\_\([z\_\(n - 1\), z\_n]\)\), 
            StyleBox["f",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Calcula la integral de la funci\[OAcute]n",
  Cell[BoxData[
      \(TraditionalForm\`\(\ f \((x, y)\) = x\ y\)\)]],
  " a lo largo de la poligonal [(1,0),(0,1),(-1,0),(1,0)]."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral de l\[IAcute]nea de un campo vectorial", "Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\^n\)]],
  " una curva suave y sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", "A"}], "\[Rule]", 
          \(\[DoubleStruckCapitalR]\^n\)}], TraditionalForm]]],
  " un campo vectorial continuo definido en un conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^n\)]],
  " que contiene a la imagen de \[Gamma], esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](\([a, b]\)) \[Subset] A\)]],
  ". La componente tangencial de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " sobre \[Gamma] en un punto \[Gamma](t) es la proyecci\[OAcute]n ortogonal \
del vector ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(\[Gamma](t)) sobre el vector tangente unitario a \[Gamma] en el punto \
\[Gamma](t), es decir, el vector \[LeftAngleBracket]",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(\[Gamma](t)) | ",
  StyleBox["T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(t)\[RightAngleBracket]",
  StyleBox["T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(t) donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          FormBox[\(\[Gamma]\ ' \(\((t)\)/\) || \[Gamma]\ ' \((t)\) || \),
            "TraditionalForm"]}], TraditionalForm]]],
  ". Es usual representar por ",
  StyleBox["F.T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " el campo escalar que a cada punto de la curva \[Gamma] hace corresponder \
el producto escalar \[LeftAngleBracket]",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(\[Gamma](t)) | ",
  StyleBox["T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(t)\[RightAngleBracket]. La integral de l\[IAcute]nea de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["  ",
    FontSlant->"Italic"],
  "sobre \[Gamma] se define como la integral de l\[IAcute]nea del campo \
escalar ",
  StyleBox["F.T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " sobre \[Gamma], esto es, el n\[UAcute]mero dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox["T",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{\(\[Integral]\_a\%b\), 
                RowBox[{"\[LeftAngleBracket]", 
                  RowBox[{
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                    "|", " ", 
                    RowBox[{
                      StyleBox["T",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((t)\)}]}], 
                  "\[RightAngleBracket]"}]}], "||", \(\[Gamma]\ ' \((t)\)\), 
              "||", \(\[DifferentialD]t\)}], "=", 
            RowBox[{\(\[Integral]\_a\%b\), 
              RowBox[{
                RowBox[{"\[LeftAngleBracket]", 
                  RowBox[{
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                    "|", " ", \(\[Gamma]' \((t)\)\)}], 
                  "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Expresando el campo vectorial y la curva por medio de sus funciones \
componentes  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", "x", ")"}], "=", 
          \((\(F\_1\)(x), \(F\_2\)(x),  ... , \(F\_n\)(x))\)}], 
        TraditionalForm]]],
  " y",
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["\[Gamma]",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          \((\(\[Gamma]\_1\)(t), \(\[Gamma]\_2\)(t),  ... , 
            \(\[Gamma]\_n\)(t))\)}], TraditionalForm]]],
  ", tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                  "|", " ", \(\[Gamma]' \((t)\)\)}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{\(\[Sum]\+\(k = 1\)\%n\), 
            RowBox[{
              RowBox[{\(\[Integral]\_a\%b\), 
                RowBox[{
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], "k"], \((\[Gamma] \((t)\))\), 
                  SubsuperscriptBox["\[Gamma]", "k", 
                    RowBox[{" ", 
                      StyleBox["\[VerticalLine]",
                        FontWeight->"Bold"], 
                      StyleBox[" ",
                        FontWeight->"Bold"]}]], \((t)\), 
                  \(\[DifferentialD]t\)}]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["Para esta integral suelen emplearse las notaciones ", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Integral]\_\[Gamma]\), 
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox["T",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          RowBox[{
            StyleBox["\[DifferentialD]",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["s",
              FontSlant->"Italic"]}], 
          StyleBox["      ",
            FontSlant->"Italic"], "y", "     ", 
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[\(\[DifferentialD]\[Gamma]\),
                FontWeight->"Bold"]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "No olvides que con frecuencia en F\[IAcute]sica se usa la letra ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en lugar de \[Gamma] para representar la curva sobre la que se integra."
}], "Text"],

Cell[TextData[{
  "Para ",
  Cell[BoxData[
      \(TraditionalForm\`n = 2\)]],
  ", poniendo ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", 
          RowBox[{\((x(t), y(t))\), "=", 
            RowBox[{
              RowBox[{\(x(t)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(y(t)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{\((P \((x, y)\), Q \((x, y)\))\), "=", 
            RowBox[{
              RowBox[{\(P(x, y)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{\(Q(x, y)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  ", la integral anterior es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "(", 
                    StyleBox[\(x(t), y(t)\),
                      FontSlant->"Italic"], ")"}], "|", 
                  RowBox[{"(", 
                    StyleBox[\(x\ ' \((t)\), y\ ' \((t)\)\),
                      FontSlant->"Italic"], ")"}]}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{"P", "(", 
                      StyleBox[\(x(t), y(t)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(x\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}], "+", 
                  RowBox[{
                    RowBox[{"Q", "(", 
                      StyleBox[\(x(t), y(t)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(y\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}]}], 
                ")"}], \(\[DifferentialD]t\)}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["En este caso son frecuentee la notaciones", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["P",
                FontSlant->"Italic"], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["x",
                  FontSlant->"Italic"]}]}]}], "+", 
          RowBox[{
            StyleBox["Q",
              FontSlant->"Italic"], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"], 
            RowBox[{"\[DifferentialD]", 
              StyleBox["y",
                FontWeight->"Plain",
                FontSlant->"Italic"]}], 
            StyleBox["          ",
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["o",
              FontWeight->"Plain"], 
            StyleBox["           ",
              FontWeight->"Plain"], 
            RowBox[{\(\[Integral]\_\[Gamma]\), 
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["\[DifferentialD]",
                    FontSlant->"Plain"], 
                  StyleBox["x",
                    FontSlant->"Italic"]}]}]}]}], "+", 
          RowBox[{
            StyleBox["Q",
              FontSlant->"Italic"], 
            RowBox[{"\[DifferentialD]", 
              StyleBox["y",
                FontWeight->"Plain",
                FontSlant->"Italic"]}]}]}], 
        StyleBox[" ",
          FontWeight->"Plain",
          FontSlant->"Italic"]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "para representar la integral de l\[IAcute]nea del campo vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\(P(x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " sobre \[Gamma]."
}], "Text"],

Cell[TextData[{
  "Para",
  Cell[BoxData[
      \(TraditionalForm\`\(\ n = 3\)\)]],
  ", poniendo ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", 
          RowBox[{\((x(t), y(t), \ z(t))\), "=", 
            RowBox[{
              RowBox[{\(x(t)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{\(y(t)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{\(z(t)\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{\((P(x, y, z), Q(x, y, z), R(x, y, z))\), "=", 
            RowBox[{
              RowBox[{"P", \((x, y, z)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{"Q", \((x, y, z)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{"R", \((x, y, z)\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  ", tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    RowBox[{"(", 
                      StyleBox[\(x \((t)\), y \((t)\), \ z \((t)\)\),
                        FontSlant->"Italic"], ")"}]}], "|", 
                  RowBox[{"(", 
                    StyleBox[\(x\ ' \((t)\), y\ ' \((t)\), z\ ' \((t)\)\),
                      FontSlant->"Italic"], ")"}]}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    StyleBox["P",
                      FontSlant->"Italic"], 
                    RowBox[{"(", 
                      StyleBox[\(x \((t)\), y \((t)\), z \((t)\)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(x\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}], "+", 
                  RowBox[{
                    StyleBox["Q",
                      FontSlant->"Italic"], 
                    RowBox[{"(", 
                      StyleBox[\(x \((t)\), y \((t)\), z \((t)\)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(y\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}], "+", 
                  RowBox[{
                    StyleBox["R",
                      FontSlant->"Italic"], 
                    RowBox[{"(", 
                      StyleBox[\(x \((t)\), y \((t)\), z \((t)\)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(z\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}]}], ")"}], 
              \(\[DifferentialD]t\)}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["En este caso son frecuentes la notaciones", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          RowBox[{
            StyleBox["P",
              FontSlant->"Italic"], 
            StyleBox[\((x, y, z)\),
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontSlant->"Plain"], 
              StyleBox["x",
                FontSlant->"Italic"]}]}]}], "+", 
        RowBox[{
          StyleBox["Q",
            FontSlant->"Italic"], 
          StyleBox[\((x, y, z)\),
            FontSlant->"Italic"], 
          RowBox[{"\[DifferentialD]", 
            StyleBox["y",
              FontWeight->"Plain",
              FontSlant->"Italic"]}]}], 
        StyleBox["+",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain",
          FontSlant->"Italic"], 
        RowBox[{
          StyleBox["R",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          StyleBox[\((x, y, z)\),
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          RowBox[{
            StyleBox["\[DifferentialD]",
              FontWeight->"Plain",
              FontSlant->"Plain"], 
            StyleBox["z",
              FontWeight->"Plain",
              FontSlant->"Italic"]}], 
          StyleBox["        ",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          StyleBox["o",
            FontWeight->"Plain"], 
          StyleBox["            ",
            FontWeight->"Plain"], 
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["P",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["x",
                  FontSlant->"Italic"]}]}]}]}], "+", 
        RowBox[{
          StyleBox["Q",
            FontSlant->"Italic"], 
          RowBox[{"\[DifferentialD]", 
            StyleBox["y",
              FontWeight->"Plain",
              FontSlant->"Italic"]}]}], 
        StyleBox["+",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain",
          FontSlant->"Italic"], 
        RowBox[{
          StyleBox["R",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          RowBox[{
            StyleBox["\[DifferentialD]",
              FontWeight->"Plain",
              FontSlant->"Plain"], 
            StyleBox["z",
              FontWeight->"Plain",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "para representar la integral de l\[IAcute]nea del campo vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{\(P(x, y, z)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(Q(x, y, z)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Bold"], "+", " ", 
            RowBox[{\(R(x, y, z)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " sobre \[Gamma]."
}], "Text"],

Cell[TextData[{
  "La integral de l\[IAcute]nea de un campo vectorial sobre una curva suave \
depende de la ",
  StyleBox["orientaci\[OAcute]n",
    FontWeight->"Bold"],
  " de la misma. Precisemos esta idea. Toda curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma] : \([a, 
            b]\) \[Rule] \[DoubleStruckCapitalR]\^n\)]],
  " tiene una ",
  StyleBox["orientaci\[OAcute]n natural",
    FontSlant->"Italic"],
  " que es la que establece el sentido de recorrido de la curva conforme el \
punto \[Gamma](t) se desplaza desde \[Gamma](a) hasta \[Gamma](b) a medida \
que el par\[AAcute]metro ",
  StyleBox["t",
    FontSlant->"Italic"],
  " aumenta desde ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\)]],
  " hasta ",
  Cell[BoxData[
      \(TraditionalForm\`t = b\)]],
  ". La curva  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Tilde]\)\(\[Gamma] : \([a, 
              b]\)\)\) \[Rule] \[DoubleStruckCapitalR]\^n\)]],
  " definida por ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Tilde]\)\(\[Gamma](t)\)\) = \[Gamma](
          a + b - t)\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([a, b]\)\)]],
  ", se llama ",
  StyleBox["curva opuesta",
    FontWeight->"Bold"],
  " de \[Gamma]. Observa que \[Tilde]\[Gamma] es la misma curva \[Gamma] \
recorrida en sentido contrario pues el punto \[Tilde]\[Gamma](t) se desplaza \
desde \[Gamma](b) hasta \[Gamma](a) a medida que el par\[AAcute]metro ",
  StyleBox["t",
    FontSlant->"Italic"],
  " aumenta desde ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\)]],
  " hasta ",
  Cell[BoxData[
      \(TraditionalForm\`t = b\)]],
  ". Teniendo en cuenta que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Tilde]\)\(\[Gamma]\ ' \((t)\)\)\) = \
\(-\[Gamma]\ '\) \((a + b - t)\)\)]],
  " tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\( \[Tilde] \[Gamma]\)\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((\[Gamma] \((a + b - t)\))\)}], 
                  " ", "|", " ", \(\(-\[Gamma]'\) \((a + b - t)\)\)}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{\([a + b - t = u]\), "=", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{\(\[Integral]\_a\%b\), 
                  RowBox[{
                    RowBox[{"\[LeftAngleBracket]", 
                      RowBox[{
                        RowBox[{
                          StyleBox["F",
                            FontWeight->"Bold",
                            FontSlant->"Italic"], \((\[Gamma] \((u)\))\)}], 
                        " ", "|", " ", \(\[Gamma]' \((u)\)\)}], 
                      "\[RightAngleBracket]"}], \(\[DifferentialD]u\)}]}]}], 
              "=", 
              RowBox[{"-", 
                RowBox[{\(\[Integral]\_\[Gamma]\), 
                  StyleBox["F",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
La integral de l\[IAcute]nea de un campo vectorial sobre un camino formado \
por yuxtaposici\[OAcute]n de curvas suaves se define como la suma de las \
integrales de l\[IAcute]nea de dicho campo vectorial sobre las curvas suaves \
que forman el camino.\
\>", "Text"],

Cell["Ejemplos", "Example"],

Cell[TextData[{
  "Trabajo",
  StyleBox[". Consideremos un camino ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"r", 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox[\([a, b]\),
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" cuya imagen est\[AAcute] en una regi\[OAcute]n ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(A \[Subset] \[DoubleStruckCapitalR]\^n\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["en la que est\[AAcute] definido un campo vectorial ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"F", 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox["A",
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" que a cada punto ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox["\[Element]",
            FontWeight->"Plain"], 
          StyleBox["A",
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" asigna un vector ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox["(",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[") ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["que interpretamos como una fuerza que act\[UAcute]a en ",
    FontWeight->"Plain"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[". El trabajo realizado por el campo de fuerzas ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" al desplazar una part\[IAcute]cula a lo largo del camino ",
    FontWeight->"Plain"],
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox[" viene dado por la integral de l\[IAcute]nea de ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" sobre el camino ",
    FontWeight->"Plain"],
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox[".",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{"Trabajo", "=", 
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"]], 
          StyleBox[\(F . dr\),
            FontWeight->"Bold",
            FontSlant->"Italic"]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["Ley de Amp\[EGrave]re",
    FontWeight->"Bold"],
  ". ",
  StyleBox["Se comprueba experimentalmente que un largo alambre recto que \
lleva una corriente estacionaria I produce un campo magn\[EAcute]tico ",
    FontFamily->"Times New Roman"],
  StyleBox["B",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". La relaci\[OAcute]n entre la corriente I del conductor y el ",
    FontFamily->"Times New Roman"],
  "campo magn\[EAcute]tico (densidad de flujo magn\[EAcute]tico) ",
  StyleBox["B",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox["producido por la misma, viene dada por la ley de Amp\[EAcute]re \
que establece que la integral de l\[IAcute]nea de ",
    FontFamily->"Times New Roman"],
  StyleBox["B",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" sobre cualquier curva de Jordan suave ",
    FontFamily->"Times New Roman"],
  StyleBox["r",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" que rodee al conductor es igual a ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\_0\)]],
  "I."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"]], 
          StyleBox[\(B . dr\),
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", \(\(\[Mu]\_0\) I\)}], TextForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Circulaci\[OAcute]n de un campo vectorial a lo largo de un camino",
  StyleBox[". Consideremos un camino ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"r", 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox[\([a, b]\),
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" cuya imagen est\[AAcute] en una regi\[OAcute]n ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(A \[Subset] \[DoubleStruckCapitalR]\^n\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["en la que est\[AAcute] definido un campo vectorial ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"F", 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox["A",
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[". La circulaci\[OAcute]n de ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" a lo largo del camino ",
    FontWeight->"Plain"],
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox[" es el n\[UAcute]mero dado por ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"]], 
          StyleBox[\(F . dr\),
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TextForm]]],
  StyleBox[
  ". Como acabamos de ver, dependiendo de su naturaleza, la \
circulaci\[OAcute]n de un campo admite distintas interpretaciones.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "Calcula la integral de los siguientes campos vectoriales, ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", a lo largo de los caminos ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " que se indican en cada caso.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
            RowBox[{
              RowBox[{\(\(x\ \)\^2\), \(y\^3\), " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox["-",
                FontWeight->"Bold"], 
              RowBox[{"y", " ", \(\@x\), " ", 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"], "(", "t", ")"}], "=", " ", 
            RowBox[{
              RowBox[{\(t\^2\), " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "-", "  ", 
              RowBox[{\(\(t\ \)\^3\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"x", "  ", "y", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"y", " ", "z", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"z", " ", "x", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", " ", 
          RowBox[{
            RowBox[{"t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", "  ", 
            RowBox[{\(\(t\ \)\^2\), 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(t\^3\), " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"x", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"y", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"z", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", 
          RowBox[{
            RowBox[{"sen", " ", "t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"cos", " ", "t", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"t", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"y", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(-x\), " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", "  ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", 
          RowBox[{
            RowBox[{\(cos\^3\), " ", "t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(sen\^3\), " ", "t", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", 
            RowBox[{\((\ t\^3/2  \[Pi])\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \@\(2  \[Pi]\)\%3\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Calcula las siguientes integrales:\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], " ", \(x\ y\ \[DifferentialD]x\)}], 
          "+", \(\((x - y)\) \[DifferentialD]y\)}], TraditionalForm]]],
  ", donde ",
  Cell[BoxData[
      FormBox[
        StyleBox["r",
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  " es la poligonal [(0,0),(2,0),(3,2)].\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], " ", \(x\ \@y\ \[DifferentialD]x\)}], 
          "+", \(2  y \(\@ x\) \[DifferentialD]y\)}], TraditionalForm]]],
  ", donde ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es el camino formado por la yuxtaposici\[OAcute]n del primer cuadrante de \
la circunferencia unidad y el segmento [(0,1),(4,3)].\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[Integral]",
              FontWeight->"Bold"], 
            StyleBox["r",
              FontWeight->"Bold"]], " ", 
          \(\((x\ y\  + log\ x)\) \[DifferentialD]y\)}], TraditionalForm]]],
  ", donde ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es el segmento de la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  "desde el punto (1,1) al punto (3,9).\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], " ", \(y\ z\ \ \[DifferentialD]y\)}], 
          "+", \(x\ y\ \ \[DifferentialD]z\)}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"], "(", "t", ")"}], "=", " ", 
          RowBox[{
            RowBox[{\(\@t\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", "  ", 
            RowBox[{"t", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", 
            RowBox[{\(t\^2\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Calcula el trabajo realizado por el campo de fuerzas",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], "(", \(x, y\), ")"}], "=", 
            \((x + \ y, \ x - y)\)}]}], TraditionalForm]]],
  " para llevar un punto material desde el origen de coordenadas hasta el \
punto (2,0) en cada uno de los siguientes casos:\na) A trav\[EAcute]s del \
segmento que une dichos puntos.\nb) A trav\[EAcute]s de la semicircunferencia \
",
  Cell[BoxData[
      \(TraditionalForm\`\((x - 1)\)\^2 + y\^2 = 1, \ 
      y \[GreaterEqual] 0. \)]],
  "\nc) A trav\[EAcute]s de la semicircunferencia ",
  Cell[BoxData[
      \(TraditionalForm\`\((x - 1)\)\^2 + y\^2 = 1, \ y \[LessEqual] 0. \)]]
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  "Calcula el trabajo realizado por el campo de fuerzas",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], "(", \(x, y, z\), ")"}], "=", 
            \((x, y, z)\)}]}], TraditionalForm]]],
  " para llevar un punto material desde el origen de coordenadas hasta el \
punto (1,1,1) en cada uno de los siguientes casos:\na) A trav\[EAcute]s del \
segmento que une dichos puntos.\nb) A trav\[EAcute]s de la poligonal ",
  Cell[BoxData[
      \(TraditionalForm
      \`\([\((0, 0, 0)\), \((1, 0, 0)\), \((1, 1, 0)\), \((1, 1, 1)\)]\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "Calcula el trabajo realizado por el campo gravitacional creado por una \
masa ",
  StyleBox["M",
    FontSlant->"Italic"],
  " situada en el origen de coordenadas para trasladar una part\[IAcute]cula \
de masa unidad desde el punto (1,1,1) al punto (2,2,2) a trav\[EAcute]s del \
segmento que une dichos puntos."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Campos vectoriales. Integrales de l\[IAcute]nea"], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Campos vectoriales. Integrales de l\[IAcute]nea"], 
        "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.42.1"->{
    Cell[7586, 235, 61, 1, 71, "Input",
      CellTags->"S5.42.1"],
    Cell[7650, 238, 63, 1, 71, "Input",
      CellTags->"S5.42.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.42.1", 86908, 2696}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 64, 0, 99, "Title"],
Cell[1821, 53, 188, 6, 102, "Author"],

Cell[CellGroupData[{
Cell[2034, 63, 37, 0, 93, "Section"],
Cell[2074, 65, 2105, 65, 199, "Text"],
Cell[4182, 132, 1499, 39, 114, "Text"],
Cell[5684, 173, 1405, 41, 119, "Text"],
Cell[7092, 216, 108, 4, 41, "Text"],
Cell[7203, 222, 193, 5, 67, "Text"],
Cell[7399, 229, 184, 4, 67, "Text"],
Cell[7586, 235, 61, 1, 71, "Input",
  CellTags->"S5.42.1"],
Cell[7650, 238, 63, 1, 71, "Input",
  CellTags->"S5.42.1"],
Cell[7716, 241, 198, 4, 149, "Input"],
Cell[7917, 247, 288, 5, 175, "Input"],
Cell[8208, 254, 99, 2, 41, "Text"],
Cell[8310, 258, 535, 15, 35, "Text"],
Cell[8848, 275, 89, 2, 41, "Text"],
Cell[8940, 279, 664, 18, 35, "Text"],
Cell[9607, 299, 27, 0, 51, "Example"],
Cell[9637, 301, 512, 16, 68, "Text"],
Cell[10152, 319, 398, 13, 57, "Text"],
Cell[10553, 334, 1372, 44, 119, "Text"],
Cell[11928, 380, 577, 18, 60, "Text"],
Cell[12508, 400, 93, 2, 41, "Text"],
Cell[12604, 404, 2282, 65, 63, "Text"],
Cell[14889, 471, 499, 16, 68, "Text"],
Cell[15391, 489, 370, 11, 58, "Text"],
Cell[15764, 502, 1492, 49, 120, "Text"],
Cell[17259, 553, 570, 17, 60, "Text"],
Cell[17832, 572, 290, 10, 42, "Text"],
Cell[18125, 584, 1143, 34, 61, "Text"],
Cell[19271, 620, 622, 20, 67, "Text"],
Cell[19896, 642, 301, 6, 62, "Text"],
Cell[20200, 650, 556, 21, 42, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20793, 676, 46, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[20864, 680, 67, 0, 78, "Subsection"],
Cell[20934, 682, 971, 27, 67, "Text"],
Cell[21908, 711, 446, 13, 64, "Text"],
Cell[22357, 726, 214, 8, 41, "Text"],
Cell[22574, 736, 765, 22, 64, "Text"],
Cell[23342, 760, 227, 8, 41, "Text"],
Cell[23572, 770, 870, 24, 64, "Text"],
Cell[24445, 796, 194, 5, 41, "Text"],
Cell[24642, 803, 348, 10, 63, "Text"],
Cell[24993, 815, 409, 10, 67, "Text"],
Cell[25405, 827, 441, 11, 64, "Text"],
Cell[25849, 840, 167, 2, 41, "Text"],
Cell[26019, 844, 917, 25, 63, "Text"],
Cell[26939, 871, 479, 9, 93, "Text"],
Cell[27421, 882, 1145, 29, 165, "Text"],
Cell[28569, 913, 1721, 45, 86, "Text"],
Cell[30293, 960, 205, 5, 41, "Text"],

Cell[CellGroupData[{
Cell[30523, 969, 31, 0, 68, "Exercise"],
Cell[30557, 971, 1268, 43, 177, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31862, 1019, 31, 0, 68, "Exercise"],
Cell[31896, 1021, 281, 8, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32214, 1034, 31, 0, 68, "Exercise"],
Cell[32248, 1036, 421, 12, 67, "ExerciseText"],
Cell[32672, 1050, 480, 10, 93, "Text"],
Cell[33155, 1062, 845, 22, 93, "Text"],
Cell[34003, 1086, 581, 15, 63, "Text"],
Cell[34587, 1103, 519, 15, 67, "Text"],
Cell[35109, 1120, 596, 15, 60, "Text"],
Cell[35708, 1137, 1447, 32, 197, "Text"],
Cell[37158, 1171, 176, 5, 60, "Text"],
Cell[37337, 1178, 494, 12, 93, "Text"],
Cell[37834, 1192, 1288, 39, 119, "Text"],
Cell[39125, 1233, 972, 26, 63, "Text"],
Cell[40100, 1261, 1530, 50, 157, "Text"],
Cell[41633, 1313, 670, 20, 64, "Text"],
Cell[42306, 1335, 646, 16, 119, "Text"],
Cell[42955, 1353, 503, 9, 229, "Input"],
Cell[43461, 1364, 258, 6, 41, "Text"],
Cell[43722, 1372, 633, 18, 64, "Text"],
Cell[44358, 1392, 478, 10, 93, "Text"],
Cell[44839, 1404, 752, 20, 64, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45628, 1429, 31, 0, 68, "Exercise"],
Cell[45662, 1431, 214, 5, 41, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45925, 1442, 69, 0, 78, "Subsection"],
Cell[45997, 1444, 2365, 75, 175, "Text"],
Cell[48365, 1521, 1739, 45, 64, "Text"],
Cell[50107, 1568, 735, 25, 68, "Text"],
Cell[50845, 1595, 1296, 32, 74, "Text"],
Cell[52144, 1629, 67, 0, 41, "Text"],
Cell[52214, 1631, 1015, 30, 63, "Text"],
Cell[53232, 1663, 240, 6, 42, "Text"],
Cell[53475, 1671, 1009, 32, 67, "Text"],
Cell[54487, 1705, 1719, 44, 64, "Text"],
Cell[56209, 1751, 57, 0, 41, "Text"],
Cell[56269, 1753, 1707, 50, 63, "Text"],
Cell[57979, 1805, 541, 16, 41, "Text"],
Cell[58523, 1823, 1295, 38, 67, "Text"],
Cell[59821, 1863, 2401, 58, 111, "Text"],
Cell[62225, 1923, 57, 0, 41, "Text"],
Cell[62285, 1925, 2589, 81, 63, "Text"],
Cell[64877, 2008, 723, 21, 41, "Text"],
Cell[65603, 2031, 1820, 53, 171, "Text"],
Cell[67426, 2086, 1541, 37, 64, "Text"],
Cell[68970, 2125, 276, 5, 67, "Text"],
Cell[69249, 2132, 27, 0, 51, "Example"],
Cell[69279, 2134, 2430, 81, 122, "Text"],
Cell[71712, 2217, 357, 11, 60, "Text"],
Cell[72072, 2230, 1243, 36, 122, "Text"],
Cell[73318, 2268, 369, 12, 60, "Text"],
Cell[73690, 2282, 2023, 62, 122, "Text"],

Cell[CellGroupData[{
Cell[75738, 2348, 31, 0, 68, "Exercise"],
Cell[75772, 2350, 4750, 147, 178, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[80559, 2502, 31, 0, 68, "Exercise"],
Cell[80593, 2504, 2709, 84, 211, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[83339, 2593, 31, 0, 68, "Exercise"],
Cell[83373, 2595, 861, 21, 169, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84271, 2621, 31, 0, 68, "Exercise"],
Cell[84305, 2623, 720, 18, 135, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85062, 2646, 31, 0, 68, "Exercise"],
Cell[85096, 2648, 351, 8, 93, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

